% $Id: miunlett.cls 156 2013-02-01 16:57:27Z danbos $
%%
%% This is file is based on `kth-brev.cls'.
%%
% XXX rewrite entirely according to the university letter style.
% XXX make all text in the class use the translator-package.
\NeedsTeXFormat{LaTeX2e}[2000/01/01]
\ProvidesClass{miunlett}
              [2011/10/12 v1.0 (draft) MiUn brev]
\DeclareOption{a4paper}{}
\DeclareOption{a5paper}{\OptionNotUsed}
\DeclareOption{b5paper}{\OptionNotUsed}
\DeclareOption{letterpaper}{\OptionNotUsed}
\DeclareOption{legalpaper}{\OptionNotUsed}
\DeclareOption{executivepaper}{\OptionNotUsed}
\DeclareOption{landscape}{\OptionNotUsed}
\setlength\paperheight{297mm}
\setlength\paperwidth {210mm}
\DeclareOption{10pt}{\renewcommand\@ptsize{0}}
\DeclareOption{11pt}{\renewcommand\@ptsize{1}}
\DeclareOption{12pt}{\renewcommand\@ptsize{2}}
\newcommand{\@ptsize}{1}
\DeclareOption{twoside}{\@twosidetrue  \@mparswitchtrue}
\DeclareOption{oneside}{\@twosidefalse \@mparswitchfalse}
\DeclareOption{draft}{\setlength\overfullrule{5pt}}
\DeclareOption{final}{\setlength\overfullrule{0pt}}
\DeclareOption{leqno}{\input{leqno.clo}}
\DeclareOption{fleqn}{\input{fleqn.clo}}
\newif\if@miunlett@head \@miunlett@headtrue
\newif\if@miunlett@foot \@miunlett@foottrue
\DeclareOption{nohead}{\@miunlett@headfalse}
\DeclareOption{nofoot}{\@miunlett@footfalse}
\newcommand{\@miunlett@layout}{MiUn}
\DeclareOption{DIN}{\renewcommand\@miunlett@layout{DIN}}
\DeclareOption{SS}{\renewcommand\@miunlett@layout{SS}}
\newcommand{\@miunlett@logo}{\@miunlett@default@logo}
\newcommand{\@miunlett@logocol}{CMYK}
\newcommand{\@miunlett@logoname}{int}
\newif\if@miunlett@forcedcolor \@miunlett@forcedcolorfalse
\newcommand{\logotype}[1]{\renewcommand{\@miunlett@logo}{#1}}
\newcommand{\logoname}[1]{\renewcommand{\@miunlett@logoname}{#1}}
\DeclareOption{color}{%
  \@miunlett@forcedcolortrue}
\DeclareOption{colour}{%
  \@miunlett@forcedcolortrue}
\DeclareOption{bw}{%
  \@miunlett@forcedcolortrue
  \renewcommand{\@miunlett@logocol}{sv}}
\DeclareOption{b&w}{%
  \@miunlett@forcedcolortrue
  \renewcommand{\@miunlett@logocol}{sv}}
\DeclareOption{sv}{%
  \@miunlett@forcedcolortrue
  \renewcommand{\@miunlett@logocol}{sv}}
\ProcessOptions
\RequirePackage[T1]{fontenc}
\RequirePackage{geometry}
\RequirePackage{graphics}
\RequirePackage{ifpdf}
\RequirePackage[T1]{url}
\input{size1\@ptsize.clo}
\if@twoside
\geometry{a4paper,twoside,nohead,footskip=10mm,includefoot,
          left=25mm,right=25mm,top=30mm,bottom=12mm}
\else
\geometry{a4paper,nohead,footskip=10mm,includefoot,
          left=25mm,right=25mm,top=30mm,bottom=12mm}
\fi
\if@miunlett@forcedcolor
\else
  \ifpdf
    \renewcommand{\@miunlett@logocol}{CMYK}
  \else
    \renewcommand{\@miunlett@logocol}{sv}
  \fi
\fi
\newcommand{\@miunlett@default@logo}{MU_logotyp_\@miunlett@logoname_\@miunlett@logocol}

\setlength{\lineskip}{1pt}
\setlength{\normallineskip}{1pt}
\renewcommand\baselinestretch{}
\setlength{\parskip}{0.7em}
\setlength{\parindent}{0pt}
\setlength{\medskipamount}{\parskip}
\newdimen\longindentation
\longindentation=.5\textwidth
\newdimen\indentedwidth
\indentedwidth=\textwidth
\advance\indentedwidth -\longindentation
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301
\setlength{\footnotesep}{12pt}
\setlength{\skip\footins}{10pt \@plus 2pt \@minus 4pt}
\def\ps@empty{%
  \let\@oddfoot\@empty\let\@oddhead\@empty
  \let\@evenfoot\@empty\let\@evenhead\@empty}
\def\ps@plain{%
  \let\@oddhead\@empty
  \def\@oddfoot{\if@miunlett@foot
    \fontencoding{T1}\fontfamily{cmss}\selectfont
    \fontsize{7}{8.5}\selectfont
    \parbox{\textwidth}{\offinterlineskip
      \setlength{\lineskip}{4pt}
      \setlength{\normallineskip}{4pt}
      \begin{center}
        \makebox[\textwidth]{\hfill
          \institutename%
          \hfill
          \ifnum\@nameuse{@miunlett@lastpage\the@miunlett@letter}=1%
          \else
            \llap{\thepage
              \ifnum\@nameuse{@miunlett@lastpage\the@miunlett@letter}=0%
                \G@refundefinedtrue
              \else
                \space(\@nameuse{@miunlett@lastpage\the@miunlett@letter})%
              \fi
            }%
          \fi}\\
        \makebox[0pt]{\rule{180mm}{0.4pt}}\\
        \makebox[0pt]{\def\\{; }\strut
          \fromaddress.
          Tel:~\telephonenum.
          E-post:~\@miunlett@email}\\
        \makebox[0pt]{\strut
          \@miunlett@accounts
          \settowidth{\@tempdima}{\@miunlett@accounts}%
          \settowidth{\@tempdimb}{\@miunlett@web}%
          \ifdim\@tempdima>1pt\ifdim\@tempdimb>1pt\relax
            \space
          \fi\fi
          \@miunlett@web}
      \end{center}}\fi}
  \let\@evenfoot\@oddfoot}
\newcommand*{\name}[1]{\def\fromname{#1}}
\newsavebox{\@miunlett@signature}
\newcounter{@miunlett@signature}
\newlength{\@miunlett@signaturewidth}
\newcommand*{\signature}[2][2]{%
  \setlength{\@miunlett@signaturewidth}{\indentedwidth}%
  \divide \@miunlett@signaturewidth by #1
  \def\and{\end{tabular}\end{minipage}%
    \addtocounter{@miunlett@signature}{1}%
    \ifnum#1=\value{@miunlett@signature}%
      \setcounter{@miunlett@signature}{0}%
      \\*[5\medskipamount]%
    \fi
    \begin{minipage}[t]{\@miunlett@signaturewidth}
      \begin{tabular}[t]{@{}l}}
  \begin{lrbox}{\@miunlett@signature}\normalfont
    \begin{minipage}{\textwidth}
      \begin{minipage}[t]{\@miunlett@signaturewidth}
        \begin{tabular}[t]{@{}l}
          #2
        \end{tabular}
      \end{minipage}
    \end{minipage}
  \end{lrbox}
}
\newcommand*{\logo}[1]{\renewcommand{\@miunlett@logo}{#1}}
\newcommand*{\accounts}[1]{\def\@miunlett@accounts{#1}}
\newcommand*{\institute}[1]{\def\institutename{#1}}
\newcommand*{\address}[2][\fromaddress]{%
  \def\fromaddress{#2}\def\@miunlett@return{#1}}
\newcommand*{\location}[2][\fromlocation]{%
  \def\fromlocation{#2}\def\@miunlett@loc{#1}}
\newcommand*{\telephone}[1]{\def\telephonenum{#1}}
\newcommand*{\telefax}[1]{\def\@miunlett@fax{#1}}
\def\@miunlett@url{\begingroup \urlstyle{same}\Url}
\def\email{\urldef{\@miunlett@email}\@miunlett@url}
\def\web{\urldef{\@miunlett@web}\@miunlett@url}
\institute{Mid Sweden University}
\address[\@miunlett@loc\\SE-851\,70~Sundsvall\\Sweden]%
        {\fromlocation\\SE-851\,70~Sundsvall\\Sweden}
\location[Office]{Holmgatan 10}
\telephone{060\,-\,14\,87\,09}
%\accounts{Pg:~1~56~53-9. Bg:~895-9223. Momsreg.nr/VAT:~SE202100305401.}
\accounts{}
\date{Sundsvall, \today}
\email{firstname.lastname@miun.se}
\web{www.miun.se}
\InputIfFileExists{miunlett-site.conf}
		{\typeout{Loading site specific letter configuration file.}}
		{\typeout{miunlett-site.conf not found.}}
\InputIfFileExists{miunlett.conf}
		{\typeout{Loading local letter configuration file.}}
		{\typeout{miunlett.conf not found.}}
\AtBeginDocument{%
	%\@ifpackageloaded{babel}{\let\dateswedish=\datesymd}{}
}
\newcommand*{\returnaddress}{\fromname\\\@miunlett@return}
\newcommand*{\makelabels}{%
  \AtBeginDocument{%
     \let\@startlabels\startlabels
     \let\@mlabel\mlabel
     \if@filesw
       \immediate\write\@mainaux{\string\@startlabels}\fi}%
  \AtEndDocument{%
     \if@filesw\immediate\write\@mainaux{\string\clearpage}\fi}}
\@onlypreamble\makelabels
\newcounter{@miunlett@letter}
\def\@miunlett@writelastpage{%
  \addtocounter{page}{-1}%
  \immediate\write\@auxout{%
    \string\global\string\@namedef
    {@miunlett@lastpage\the@miunlett@letter}{\thepage}}%
  \addtocounter{page}{1}%
  \addtocounter{@miunlett@letter}{1}%
}
\AtEndDocument{\@miunlett@writelastpage}
\newenvironment{letter}[2][\relax]{%
  \newpage
  \@miunlett@writelastpage
  \@ifundefined{@miunlett@lastpage\the@miunlett@letter}%
  {\@namedef{@miunlett@lastpage\the@miunlett@letter}{0}}{}%
  \if@twoside
    \ifodd\c@page \else\thispagestyle{empty}\null\newpage\fi
  \fi
  \setcounter{page}{1}%
  \setcounter{footnote}{0}%
  \interlinepenalty=200 % smaller than the TeXbook value
  \def\@miunlett@dnr{#1}%
  \@processto{\leavevmode\ignorespaces #2}%
}{%
  \stopletter\par\pagebreak\par
  \if@filesw
    \begingroup
    \let\\=\relax
    \let\protect\@unexpandable@protect
    \immediate\write\@auxout{%
      \string\@mlabel{\returnaddress}{\toname\\\toaddress}}%
    \endgroup
  \fi
}
\long\def\@processto#1{%
  \@xproc #1\\@@@%
  \ifx\toaddress\@empty
  \else
    \@yproc #1@@@%
  \fi}
\long\def\@xproc #1\\#2@@@{\def\toname{#1}\def\toaddress{#2}}
\long\def\@yproc #1\\#2@@@{\def\toaddress{#2}}
\newcommand*{\stopbreaks}{%
  \interlinepenalty\@M
  \def\par{\@@par\nobreak}%
  \let\\\@nobreakcr
  \let\vspace\@nobreakvspace}
\DeclareRobustCommand\@nobreakvspace
   {\@ifstar\@nobreakvspacex\@nobreakvspacex}
\def\@nobreakvspacex#1{%
  \ifvmode
    \nobreak\vskip #1\relax
  \else
    \@bsphack\vadjust{\nobreak\vskip #1}\@esphack
  \fi}
\def\@nobreakcr{\@ifstar{\@normalcr*}{\@normalcr*}}
\newcommand*{\startbreaks}{%
  \let\\\@normalcr
  \interlinepenalty 200%
  \def\par{\@@par\penalty 200\relax}}
\newcommand*{\@miunlett@DIN}{%
  \put(5,-105){\line(1,0){2}}
  \put(5,-210){\line(1,0){2}}
  \put(148,-5){\line(0,-1){2}}
  \put( 20,-45){\line( 1,0){1}}  \put( 20,-45){\line(0,-1){1}}
  \put(105,-45){\line(-1,0){1}}  \put(105,-45){\line(0,-1){1}}
  \put( 20,-50){\line( 1,0){1}}
  \put(105,-50){\line(-1,0){1}}
  \put( 20,-90){\line( 1,0){1}}  \put( 20,-90){\line(0, 1){1}}
  \put(105,-90){\line(-1,0){1}}  \put(105,-90){\line(0, 1){1}}
  \put( 25,-50){\makebox(0,5)[l]{\tiny
      \parbox{105mm}{\def\\{; }\noindent
				\fromname\\MiUn -- \@miunlett@return}}}
  \put( 25,-90){\makebox(0,40)[l]{%
      \begin{tabular}{@{}l}\toname\\\toaddress\end{tabular}}}}
\newcommand*{\@miunlett@KTH}{%
  \put(5,-105){\line(1,0){2}}
  \put(5,-210){\line(1,0){2}}
  \put(25,-80){\makebox(0,0)[lb]{%
      \begin{tabular}{@{}l}\toname\\\toaddress\end{tabular}}}}
\newcommand*{\@miunlett@SS}{%
  \put(5,-105){\line(1,0){2}}
  \put(5,-210){\line(1,0){2}}
  \put(120,-64){\makebox(0,22)[l]{%
      \begin{tabular}{@{}l}\toname\\\toaddress\end{tabular}}}}
\newcommand*{\opening}[1]{%
  \centerline{%
    \setlength{\unitlength}{1mm}
    \begin{picture}(0,55)(105,-85)
      \if@miunlett@head
        \put(105,-10){\makebox(0,0)[t]{%
            \scalebox{0.5}{\includegraphics{\@miunlett@logo}}}}
      \fi
      \@nameuse{@miunlett@\@miunlett@layout}
      \put(120,-80){\makebox(0,0)[lb]{%
          \begin{tabular}{@{}l}\@miunlett@dnr\end{tabular}}}
      \put(120,-85){\makebox(0,0)[lt]{%
          \begin{tabular}{@{}l}\@date\end{tabular}}}
    \end{picture}}
  \vspace*{5mm}
  #1\par\nobreak}
\newcommand{\closing}[1]{\par\nobreak\vspace{\parskip}%
  \stopbreaks
  \noindent
  \hspace*{\longindentation}
  \parbox{\indentedwidth}{
  #1\\[4\medskipamount]%
  \ifdim\wd\@miunlett@signature=0pt
    \fromname
  \else
    \usebox{\@miunlett@signature}%
  \fi
  \par}}
\newcommand*{\cc}[1]{%
  \par\noindent
  \parbox[t]{\textwidth}{%
    \@hangfrom{\normalfont\ccname: }%
    \ignorespaces #1\strut}\par}
\newcommand*{\encl}[1]{%
  \par\noindent
  \parbox[t]{\textwidth}{%
    \@hangfrom{\normalfont\enclname: }%
    \ignorespaces #1\strut}\par}
\newcommand*{\ps}{\par\startbreaks}
\newcommand*{\stopletter}{}
\newcount\labelcount
\newcommand*{\startlabels}{\labelcount\z@
  \pagestyle{empty}%
  \let\@texttop\relax
  \topmargin -50\p@
  \headsep \z@
  \oddsidemargin -35\p@
  \evensidemargin -35\p@
  \textheight 10in
  \@colht\textheight  \@colroom\textheight \vsize\textheight
  \textwidth 550\p@
  \columnsep 26\p@
  \ifcase \@ptsize\relax
    \normalsize
  \or
    \small
  \or
    \footnotesize
  \fi
  \baselineskip \z@
  \lineskip \z@
  \boxmaxdepth \z@
  \parindent \z@
  \twocolumn\relax}
\let\@startlabels=\relax
\newcommand*{\mlabel}[2]{%
  \parbox[b][2in][c]{262\p@}{\strut\ignorespaces #2}%
  }
\let\@mlabel=\@gobbletwo
\setlength\leftmargini   {2.5em}
\setlength\leftmarginii  {2.2em}
\setlength\leftmarginiii {1.87em}
\setlength\leftmarginiv  {1.7em}
\setlength\leftmarginv   {1em}
\setlength\leftmarginvi  {1em}
\setlength\leftmargin    {\leftmargini}
\setlength  \labelsep  {5\p@}
\setlength  \labelwidth{\leftmargini}
\addtolength\labelwidth{-\labelsep}
\setlength\partopsep{0\p@}
\@beginparpenalty -\@lowpenalty
\@endparpenalty   -\@lowpenalty
\@itempenalty     -\@lowpenalty
\def\@listI{\setlength\leftmargin{\leftmargini}%
            \setlength\parsep {0\p@}%
            \setlength\topsep {.4em}%
            \setlength\itemsep{.4em}}
\let\@listi\@listI
\@listi
\def\@listii {\setlength  \leftmargin{\leftmarginii}%
              \setlength  \labelwidth{\leftmarginii}%
              \addtolength\labelwidth{-\labelsep}}
\def\@listiii{\setlength  \leftmargin{\leftmarginiii}%
              \setlength  \labelwidth{\leftmarginiii}%
              \addtolength\labelwidth{-\labelsep}%
              \setlength  \topsep    {.2em}%
              \setlength  \itemsep   {\topsep}}
\def\@listiv {\setlength  \leftmargin{\leftmarginiv}%
              \setlength  \labelwidth{\leftmarginiv}%
              \addtolength\labelwidth{-\labelsep}}
\def\@listv  {\setlength  \leftmargin{\leftmarginv}%
              \setlength  \labelwidth{\leftmarginv}%
              \addtolength\labelwidth{-\labelsep}}
\def\@listvi {\setlength  \leftmargin{\leftmarginvi}%
              \setlength  \labelwidth{\leftmarginvi}%
              \addtolength\labelwidth{-\labelsep}}
\renewcommand\theenumi{\@arabic\c@enumi}
\renewcommand\theenumii{\@alph\c@enumii}
\renewcommand\theenumiii{\@roman\c@enumiii}
\renewcommand\theenumiv{\@Alph\c@enumiv}
\newcommand\labelenumi{\theenumi.}
\newcommand\labelenumii{(\theenumii)}
\newcommand\labelenumiii{\theenumiii.}
\newcommand\labelenumiv{\theenumiv.}
\renewcommand\p@enumii{\theenumi}
\renewcommand\p@enumiii{\theenumi(\theenumii)}
\renewcommand\p@enumiv{\p@enumiii\theenumiii}
\newcommand\labelitemi{\textbullet}
\newcommand\labelitemii{\normalfont\bfseries \textendash}
\newcommand\labelitemiii{\textasteriskcentered}
\newcommand\labelitemiv{\textperiodcentered}
\newenvironment{description}
               {\list{}{\labelwidth\z@ \itemindent-\leftmargin
                        \let\makelabel\descriptionlabel}}
               {\endlist}
\newcommand*{\descriptionlabel}[1]{\hspace\labelsep
                                \normalfont\bfseries #1}
\newenvironment{verse}
               {\let\\=\@centercr
                \list{}{\setlength\itemsep{\z@}%
                        \setlength\itemindent{-15\p@}%
                        \setlength\listparindent{\itemindent}%
                        \setlength\rightmargin{\leftmargin}%
                        \addtolength\leftmargin{15\p@}}%
                \item[]}
               {\endlist}
\newenvironment{quotation}
               {\list{}{\setlength\listparindent{1.5em}%
                        \setlength\itemindent{\listparindent}%
                        \setlength\rightmargin{\leftmargin}}%
                \item[]}
               {\endlist}
\newenvironment{quote}
               {\list{}{\setlength\rightmargin{\leftmargin}}%
                \item[]}
               {\endlist}
\setlength\arraycolsep{5\p@}
\setlength\tabcolsep{6\p@}
\setlength\arrayrulewidth{.4\p@}
\setlength\doublerulesep{2\p@}
\setlength\tabbingsep{\labelsep}
\skip\@mpfootins = \skip\footins
\setlength\fboxsep{3\p@}
\setlength\fboxrule{.4\p@}
\renewcommand\theequation{\@arabic\c@equation}
\DeclareOldFontCommand{\rm}{\normalfont\rmfamily}{\mathrm}
\DeclareOldFontCommand{\sf}{\normalfont\sffamily}{\mathsf}
\DeclareOldFontCommand{\tt}{\normalfont\ttfamily}{\mathtt}
\DeclareOldFontCommand{\bf}{\normalfont\bfseries}{\mathbf}
\DeclareOldFontCommand{\it}{\normalfont\itshape}{\mathit}
\DeclareOldFontCommand{\sl}{\normalfont\slshape}{\relax}
\DeclareOldFontCommand{\sc}{\normalfont\scshape}{\relax}
\DeclareRobustCommand*{\cal}{\@fontswitch{\relax}{\mathcal}}
\DeclareRobustCommand*{\mit}{\@fontswitch{\relax}{\mathnormal}}
\renewcommand\footnoterule{%
  \kern-\p@
  \hrule \@width .4\columnwidth
  \kern .6\p@}
\long\def\@makefntext#1{%
    \noindent
    \hangindent 5\p@
    \hb@xt@5\p@{\hss\@makefnmark}#1}
\newcommand*{\ccname}{cc}
\newcommand*{\enclname}{encl}
\newcommand*{\pagename}{Page}
\newcommand*{\headtoname}{To}
\newcommand*{\today}{\number\day\space \ifcase\month\or
	January\or February\or March\or April\or May\or June\or
	July\or August\or September\or October\or November\or December\fi
	\space\number\year}
\setlength\columnsep{10\p@}
\setlength\columnseprule{0\p@}
\pagestyle{plain}
\pagenumbering{arabic}
\raggedbottom
\onecolumn
\endinput
%%
%% End of file `miunlett.cls'.
